/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.MouseListener;

class BaseStack {
    private static final int textHeight = 10;
    private static final int CHIPSTACKLEFT = 180;
    private static final int CHIPSTACKSEPERATION = 40;
    private static final int CHIPSTACKBOTTOM = 405;
    private HalfPieceStack halfPieceStack;
    private ChipStack silverStack = new ChipStack(Color.lightGray, Color.lightGray, 10, "   1", 220, 405);
    private ChipStack redStack = new ChipStack(Color.red, Color.white, 10, "   5", 260, 405);
    private ChipStack greenStack = new ChipStack(Color.green, Color.white, 10, "  25", 300, 405);
    private ChipStack blackStack = new ChipStack(Color.black, Color.white, 10, " 100", 340, 405);
    private ChipStack blueStack = new ChipStack(Color.yellow, Color.red, 10, " 500", 380, 405);
    private ChipStack maroonStack = new ChipStack(Color.cyan, Color.white, 11, "2500", 420, 405);
    private int chipsBought;
    private int addedToBank;
    private Bank bank;

    BaseStack() {
        this.halfPieceStack = new HalfPieceStack(Color.gray, Color.gray, 4, "", 180, 410);
        this.blueStack.setHigher(this.maroonStack, 5);
        this.blackStack.setHigher(this.blueStack, 5);
        this.greenStack.setHigher(this.blackStack, 4);
        this.redStack.setHigher(this.greenStack, 5);
        this.silverStack.setHigher(this.redStack, 5);
        this.halfPieceStack.setHigher(this.silverStack, 2);
        this.silverStack.setChipValue(1);
    }

    public void add(Container container) {
        container.add((Component)this.maroonStack, -1);
        container.add((Component)this.blueStack, -1);
        container.add((Component)this.blackStack, -1);
        container.add((Component)this.greenStack, -1);
        container.add((Component)this.redStack, -1);
        container.add((Component)this.silverStack, -1);
        container.add((Component)this.halfPieceStack, -1);
    }

    public int getTopOfBet(int n, int n2, Graphics graphics, boolean bl) {
        if (bl) {
            return n2 - this.silverStack.getStackHeight(n) - 10;
        }
        return n2 - this.halfPieceStack.getStackHeight(n) - 10;
    }

    public void draw(int n, int n2, Graphics graphics) {
        int n3 = n2 - this.silverStack.getStackHeight(n) - 10;
        this.silverStack.DrawOnBox(n, n3, 0, graphics);
    }

    public void drawHalf(int n, int n2, Graphics graphics) {
        int n3 = n2 - this.halfPieceStack.getStackHeight(n) - 10;
        this.halfPieceStack.DrawOnBox(n, n3, 0, graphics);
    }

    public void drawHalfAbsolute(int n, int n2, int n3, Graphics graphics) {
        this.halfPieceStack.DrawOnBox(n, n2 - this.halfPieceStack.getStackHeight(n), n3, graphics);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        this.silverStack.addMouseListener(mouseListener);
        this.redStack.addMouseListener(mouseListener);
        this.greenStack.addMouseListener(mouseListener);
        this.blackStack.addMouseListener(mouseListener);
        this.blueStack.addMouseListener(mouseListener);
        this.maroonStack.addMouseListener(mouseListener);
    }

    public void addChips(int n) {
        this.addHalf(n * 2);
    }

    public void addHalf(int n) {
        this.halfPieceStack.addChips(n);
        if (this.bank != null) {
            this.bank.addToBank(n);
        }
    }

    public int countChips() {
        return this.halfPieceStack.countChips() / 2;
    }

    public int countHalfChips() {
        return this.halfPieceStack.countChips();
    }

    public void removeChips(int n) {
        this.removeHalf(n * 2);
    }

    public void removeHalf(int n) {
        this.halfPieceStack.removeChips(n);
        int n2 = -n;
        if (this.bank != null) {
            this.bank.addToBank(n2);
        }
    }

    public int getValue(Object object) {
        ChipStack chipStack = (ChipStack)object;
        return chipStack.chipValue;
    }

    public boolean buyChips(int n) {
        n = (n + 99) / 100;
        this.chipsBought += (n *= 100);
        this.addChips(n);
        return true;
    }

    public int getChipsBought() {
        return this.chipsBought;
    }

    private void addHalfToBank(int n) {
        if (this.bank != null) {
            this.bank.addToBank(n);
        }
    }

    public void setBank(Bank bank) {
        this.bank = bank;
    }
}

