/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class BasicStrategyChart
extends Dialog {
    BJOptions bjOptions;
    boolean DoubleOn10_or_11_only;
    boolean DoubleAfterSplit;
    boolean SurrenderAllowed;
    boolean MultiDeck;
    private static final String[] headingString = new String[]{"2", "3", "4", "5", "6", "7", "8", "9", "10", "Ace"};
    private static final int headingStartLeft = 60;
    private static final int underlineTop = 3;
    private static final int underlineLength = 250;
    private static final int vertLineLeft = 45;
    private static final int hardTotalsLeft = 60;
    private static final int hardTotalsTop = 50;
    private static final int lineSeperation = 20;
    private static final int columnSeperation = 25;
    private static final int softTotalsLeft = 60;
    private static final int softTotalsTop = 280;
    private static final int pairsLeft = 440;
    private static final int pairsTop = 50;
    boolean fComponentsAdjusted = false;

    public BasicStrategyChart(Frame frame, String string) {
        super(frame, string);
        this.setLayout(null);
        ((Component)this).setBackground(new Color(0, 128, 0));
        ((Component)this).setSize(756, 462);
        this.setVisible(false);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
    }

    public BasicStrategyChart(Frame frame, String string, BJOptions bJOptions, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(frame, string);
        this.bjOptions = bJOptions;
        this.bjOptions.setTempOptions(bl, bl2, bl3, bl4);
    }

    private void drawHeading(Graphics graphics, int n, int n2) {
        graphics.drawString("Dealer Upcard--->", n - 48, n2);
        int n3 = 0;
        while (n3 <= 9) {
            graphics.drawString(headingString[n3], n + n3 * 25 + 60, n2);
            ++n3;
        }
        graphics.drawLine(n, n2 + 3, n + 250 + 60, n2 + 3);
        graphics.drawString("Player", n - 48, n2 + 55);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.paint(graphics);
        this.paintHardTotalsTable(graphics);
        this.paintSoftTotalsTable(graphics);
        this.paintPairsTable(graphics);
    }

    private void paintHardTotalsTable(Graphics graphics) {
        int n = 60 + this.getInsets().left;
        int n2 = 50 + this.getInsets().top;
        this.drawHeading(graphics, n, n2);
        graphics.drawString("Hard Totals", n - 48, n2 + 75);
        graphics.drawLine(n + 45, n2 + 3, n + 45, n2 + 3 + 160);
        int n3 = 9;
        while (n3 <= 16) {
            graphics.drawString(String.valueOf(n3), n + 45 - 25, n2 + (n3 - 8) * 20);
            int n4 = 2;
            while (n4 <= 11) {
                String string = this.bjOptions.getTempBasicStrategy(n4, n3, false, false);
                graphics.drawString(string, n + 60 + 25 * (n4 - 2), n2 + (n3 - 8) * 20);
                ++n4;
            }
            ++n3;
        }
        graphics.drawString("Always Hit 8 or less", n + 45, n2 + 180);
        graphics.drawString("Always Stand on Hard 17 or above", n + 45, n2 + 200);
    }

    private void paintSoftTotalsTable(Graphics graphics) {
        int n = 60 + this.getInsets().left;
        int n2 = 280 + this.getInsets().top;
        this.drawHeading(graphics, n, n2);
        graphics.drawString("Soft Totals", n - 48, n2 + 75);
        graphics.drawLine(n + 45, n2 + 3, n + 45, n2 + 3 + 140);
        int n3 = 13;
        while (n3 <= 19) {
            graphics.drawString("A" + String.valueOf(n3 - 11), n + 45 - 25, n2 + (n3 - 12) * 20);
            int n4 = 2;
            while (n4 <= 11) {
                String string = this.bjOptions.getTempBasicStrategy(n4, n3, true, false);
                graphics.drawString(string, n + 60 + 25 * (n4 - 2), n2 + (n3 - 12) * 20);
                ++n4;
            }
            ++n3;
        }
        graphics.drawString("Always Stand on Soft 20 or above", n + 45, n2 + 160);
    }

    private void paintPairsTable(Graphics graphics) {
        int n = 440 + this.getInsets().left;
        int n2 = 50 + this.getInsets().top;
        this.drawHeading(graphics, n, n2);
        graphics.drawString("Pairs", n - 48, n2 + 75);
        graphics.drawLine(n + 45, n2 + 3, n + 45, n2 + 3 + 200);
        int n3 = 1;
        while (n3 <= 10) {
            String string = String.valueOf(n3);
            if (n3 == 1) {
                string = "A";
            }
            if (n3 == 10) {
                string = "T";
            }
            graphics.drawString(String.valueOf(string) + string, n + 45 - 25, n2 + n3 * 20);
            int n4 = 2;
            while (n4 <= 11) {
                String string2 = n3 == 1 ? this.bjOptions.getTempBasicStrategy(n4, 12, true, true) : this.bjOptions.getTempBasicStrategy(n4, n3 * 2, false, true);
                graphics.drawString(string2, n + 60 + 25 * (n4 - 2), n2 + n3 * 20);
                ++n4;
            }
            ++n3;
        }
        graphics.drawString("Y=Split", n + 45, n2 + 220);
        graphics.drawString("N=Don't Split", n + 45, n2 + 240);
        graphics.drawString("H=Hit", n + 45, n2 + 260);
        graphics.drawString("S=Stand", n + 45, n2 + 280);
        graphics.drawString("DH=Double if possible, otherwise Hit", n + 45, n2 + 300);
        graphics.drawString("DS=Double if possible, otherwise Stand", n + 45, n2 + 320);
        graphics.drawString("XH=Surrender if possible, otherwise Hit", n + 45, n2 + 340);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            ((Component)this).setLocation(rectangle.x + (rectangle.width - rectangle2.width) / 2, rectangle.y + (rectangle.height - rectangle2.height) / 2);
        }
        super.setVisible(bl);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    void HelpFrame_WindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == BasicStrategyChart.this) {
                BasicStrategyChart.this.HelpFrame_WindowClosing(windowEvent);
            }
        }

        SymWindow() {
        }
    }
}

