/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Blackjack
extends Frame
implements ActionListener,
ItemListener,
Runnable,
Bank {
    final int START = 0;
    final int WAITINGBET = 1;
    final int BETTING = 2;
    final int PLAYERS_FIRST_CARD = 3;
    final int DEALERS_FIRST_CARD = 4;
    final int PLAYERS_SECOND_CARD = 5;
    final int DEALERS_SECOND_CARD = 6;
    final int ASK_FOR_INSURANCE = 7;
    final int CHECK_DEALERS_BJ = 8;
    final int CLEAR_INSURANCE_BET = 85;
    final int CHECK_PLAYERS_BJ = 9;
    final int PLAY_PLAYERS_HANDS = 10;
    final int SHOW_DEALERS_SECOND_CARD = 11;
    final int PLAY_DEALERS_HAND = 12;
    final int DETERMINE_RESULTS = 13;
    final int RESULT_PAUSE = 14;
    final int CLEAR_HANDS = 15;
    final int SHUFFLE = 16;
    final int FRAMEWIDTH = 700;
    final int FRAMEHEIGHT = 480;
    final int betDelay = 2;
    final int clearDelay = 3;
    final int slowSpeed = 300;
    final int shuffleDelay = 3;
    final int numStartChips = 1000;
    private int handControl;
    private BJOptions bjOptions = new BJOptions();
    private int secondCard;
    private boolean optionsEnabled;
    private Bank bank;
    private BaseStack baseStack;
    private int delay;
    private Dealer dealerHand;
    private int dealerValue;
    private ShoeDeck deck;
    private Hands hands;
    private int pause;
    private boolean continueGame = true;
    private Thread t = new Thread(this);
    private boolean alreadyStarted = false;
    boolean fComponentsAdjusted = false;
    Button HelpButton = new Button();
    Button OptionsButton = new Button();
    Checkbox play2HandsCheck = new Checkbox();
    Checkbox showTotalCheck = new Checkbox();
    Label ShufflingLabel = new Label();
    LinePanel placard = new LinePanel();
    Label minLabel = new Label();
    Label maxLabel = new Label();
    Label doubleLabel = new Label();
    Label DASLabel = new Label();
    Label resplitLabel = new Label();
    Label surrenderLabel = new Label();
    Label chipsBoughtLabel = new Label();
    Label chipsOnhandLabel = new Label();
    Label netLabel = new Label();
    Label chipsBoughtAmountLabel = new Label();
    Label chipsOnhandAmountLabel = new Label();
    Checkbox basicStrategyCheckbox = new Checkbox();
    Label netAmountLabel = new Label();

    public Blackjack() {
        this.setVisible(false);
        this.setLayout(null);
        ((Component)this).setBackground(new Color(0, 128, 0));
        ((Component)this).setSize(700, 480);
        this.setVisible(false);
        this.setResizable(false);
        this.HelpButton.setLabel("Help");
        this.add(this.HelpButton);
        this.HelpButton.setFont(new Font("Dialog", 1, 12));
        this.HelpButton.setBounds(25, 400, 80, 25);
        this.OptionsButton.setLabel("Options");
        this.add(this.OptionsButton);
        this.OptionsButton.setFont(new Font("Dialog", 0, 12));
        this.OptionsButton.setBounds(25, 430, 80, 25);
        this.play2HandsCheck.setLabel("Play 2 Hands");
        this.play2HandsCheck.setLocation(115, 400);
        this.add(this.play2HandsCheck);
        this.play2HandsCheck.setBounds(115, 400, 100, 12);
        this.showTotalCheck.setLabel("Show Totals");
        this.showTotalCheck.setLocation(115, 430);
        this.add(this.showTotalCheck);
        this.showTotalCheck.setBounds(115, 420, 100, 12);
        this.ShufflingLabel.setText("Shuffling");
        this.add(this.ShufflingLabel);
        this.ShufflingLabel.setForeground(Color.black);
        this.ShufflingLabel.setFont(new Font("Dialog", 1, 20));
        this.ShufflingLabel.setBounds(288, 36, 132, 40);
        this.placard.setLayout(null);
        this.placard.setBorderColor(Color.white);
        this.add(this.placard);
        this.placard.setBackground(Color.lightGray);
        this.placard.setBounds(0, 0, 168, 96);
        this.placard.add(this.minLabel);
        this.minLabel.setForeground(Color.white);
        this.minLabel.setFont(new Font("Dialog", 1, 14));
        this.minLabel.setBounds(6, 4, 155, 16);
        this.placard.add(this.maxLabel);
        this.maxLabel.setForeground(Color.white);
        this.maxLabel.setFont(new Font("Dialog", 1, 14));
        this.maxLabel.setBounds(6, 21, 155, 16);
        this.placard.add(this.doubleLabel);
        this.doubleLabel.setForeground(Color.white);
        this.doubleLabel.setFont(new Font("Dialog", 0, 12));
        this.doubleLabel.setBounds(6, 40, 155, 12);
        this.placard.add(this.DASLabel);
        this.DASLabel.setForeground(Color.white);
        this.DASLabel.setFont(new Font("Dialog", 0, 12));
        this.DASLabel.setBounds(6, 53, 155, 12);
        this.placard.add(this.resplitLabel);
        this.resplitLabel.setForeground(Color.white);
        this.resplitLabel.setFont(new Font("Dialog", 0, 12));
        this.resplitLabel.setBounds(6, 66, 155, 12);
        this.placard.add(this.surrenderLabel);
        this.surrenderLabel.setForeground(Color.white);
        this.surrenderLabel.setFont(new Font("Dialog", 0, 12));
        this.surrenderLabel.setBounds(6, 79, 155, 12);
        this.chipsBoughtLabel.setForeground(Color.black);
        this.chipsBoughtLabel.setFont(new Font("Dialog", 0, 12));
        this.chipsBoughtLabel.setBounds(25, 336, 50, 18);
        this.chipsBoughtLabel.setText("Bought");
        this.add(this.chipsBoughtLabel);
        this.chipsOnhandLabel.setForeground(Color.black);
        this.chipsOnhandLabel.setFont(new Font("Dialog", 0, 12));
        this.chipsOnhandLabel.setBounds(25, 356, 50, 18);
        this.chipsOnhandLabel.setText("On Hand");
        this.add(this.chipsOnhandLabel);
        this.netLabel.setForeground(Color.black);
        this.netLabel.setFont(new Font("Dialog", 0, 12));
        this.netLabel.setBounds(25, 376, 50, 18);
        this.netLabel.setText("Winning");
        this.add(this.netLabel);
        this.chipsBoughtAmountLabel.setForeground(Color.black);
        this.chipsBoughtAmountLabel.setFont(new Font("Dialog", 0, 12));
        this.chipsBoughtAmountLabel.setBounds(75, 336, 70, 18);
        this.chipsBoughtAmountLabel.setText("$1000.00");
        this.chipsBoughtAmountLabel.setAlignment(2);
        this.add(this.chipsBoughtAmountLabel);
        this.chipsOnhandAmountLabel.setForeground(Color.black);
        this.chipsOnhandAmountLabel.setFont(new Font("Dialog", 0, 12));
        this.chipsOnhandAmountLabel.setBounds(75, 356, 70, 18);
        this.chipsOnhandAmountLabel.setText("$1000.00");
        this.chipsOnhandAmountLabel.setAlignment(2);
        this.add(this.chipsOnhandAmountLabel);
        this.netAmountLabel.setForeground(Color.black);
        this.netAmountLabel.setFont(new Font("Dialog", 0, 12));
        this.netAmountLabel.setBounds(75, 376, 70, 18);
        this.basicStrategyCheckbox.setLabel("Strategy");
        this.add(this.basicStrategyCheckbox);
        this.basicStrategyCheckbox.setBounds(115, 440, 100, 16);
        this.netAmountLabel.setText("$0.00");
        this.netAmountLabel.setAlignment(2);
        this.add(this.netAmountLabel);
        this.OptionsButton.addActionListener(this);
        this.HelpButton.addActionListener(this);
        this.showTotalCheck.addItemListener(this);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
    }

    public Blackjack(String string) {
        this();
        this.setTitle(string);
    }

    public void startGame(Bank bank) {
        this.setVisible(true);
        if (this.alreadyStarted) {
            return;
        }
        this.alreadyStarted = true;
        this.handControl = 0;
        this.deck = new ShoeDeck();
        this.deck.reset(this.bjOptions.numberDecks, this.bjOptions.penetration);
        this.add(this.deck);
        this.deck.setLocation(700 - this.deck.getSize().width + this.getInsets().left, this.getInsets().top);
        this.baseStack = new BaseStack();
        this.baseStack.add(this);
        this.bank = bank;
        this.baseStack.setBank(this);
        this.buyChips();
        this.hands = new Hands(this, 215, 330, this.baseStack, this.deck, this.bjOptions);
        this.dealerHand = new Dealer(this, 25, 250, this.bjOptions, this.deck);
        this.optionsEnabled = true;
        this.OptionsButton.setLabel("Options");
        this.HelpButton.setEnabled(true);
        this.play2HandsCheck.setState(true);
        this.hands.setNumStartHands(2);
        this.setPlacard();
        this.showTotalCheck.setState(false);
        this.hands.setShowTotal(this.showTotalCheck.getState());
        this.basicStrategyCheckbox.setState(false);
        this.ShufflingLabel.setVisible(false);
        this.pause = 300;
        this.t.start();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public static void main(String[] stringArray) {
        new Blackjack().setVisible(true);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Point point = componentArray[n].getLocation();
            point.translate(insets.left, insets.top);
            componentArray[n].setLocation(point);
            ++n;
        }
        this.fComponentsAdjusted = true;
    }

    public void run() {
        while (this.continueGame) {
            switch (this.handControl) {
                case 0: {
                    this.optionsEnabled = true;
                    this.OptionsButton.setLabel("Options");
                    this.handControl = 1;
                    break;
                }
                case 1: {
                    if (this.play2HandsCheck.getState()) {
                        this.hands.setNumStartHands(2);
                    } else {
                        this.hands.setNumStartHands(1);
                    }
                    if (!this.hands.betsMade()) break;
                    this.optionsEnabled = false;
                    this.OptionsButton.setLabel("Stragegy");
                    this.delay = 2;
                    this.handControl = 2;
                    this.pause = 300;
                    break;
                }
                case 2: {
                    if (!this.hands.betsMade()) {
                        this.handControl = 0;
                        this.pause = 1;
                    }
                    --this.delay;
                    if (this.hands.isNewBetMade()) {
                        this.delay = 2;
                    }
                    if (this.delay != 0) break;
                    this.handControl = 3;
                    break;
                }
                case 3: {
                    if (!this.hands.betsMade()) {
                        this.handControl = 0;
                        this.pause = 1;
                        break;
                    }
                    if (this.hands.isNewBetMade()) {
                        this.delay = 2;
                        this.handControl = 2;
                        break;
                    }
                    if (!this.hands.dealCard()) break;
                    this.handControl = 4;
                    break;
                }
                case 4: {
                    this.dealerHand.firstCard();
                    this.handControl = 5;
                    break;
                }
                case 5: {
                    if (!this.hands.dealCard()) break;
                    this.handControl = 6;
                    break;
                }
                case 6: {
                    this.pause = 1;
                    this.secondCard = this.dealerHand.secondCard();
                    if (this.secondCard == 11) {
                        this.hands.askForInsurance();
                        this.handControl = 7;
                        break;
                    }
                    this.handControl = 8;
                    break;
                }
                case 7: {
                    if (!this.hands.isInsuranceDone()) break;
                    this.handControl = 8;
                    break;
                }
                case 8: {
                    if (this.dealerHand.getValue() == 21) {
                        this.hands.dealerHasBJ(true);
                        this.dealerValue = this.dealerHand.showFirstCard();
                        this.hands.done();
                        this.pause = 300;
                        this.handControl = 13;
                        break;
                    }
                    if (this.hands.insuranceBetMade()) {
                        this.pause = 900;
                        this.handControl = 85;
                        break;
                    }
                    this.handControl = 9;
                    break;
                }
                case 85: {
                    this.hands.dealerHasBJ(false);
                    this.pause = 1;
                    this.handControl = 9;
                    break;
                }
                case 9: {
                    this.hands.checkBJs();
                    this.handControl = 10;
                    break;
                }
                case 10: {
                    this.bjOptions.setBasicStrategy(this.basicStrategyCheckbox.getState(), this.secondCard);
                    if (!this.hands.handsComplete()) break;
                    this.handControl = 11;
                    this.pause = 300;
                    break;
                }
                case 11: {
                    this.dealerValue = this.dealerHand.showFirstCard();
                    if (this.hands.allHandsDetermined()) {
                        this.handControl = 13;
                        break;
                    }
                    this.handControl = 12;
                    if (this.dealerValue < 17) break;
                    this.handControl = 13;
                    break;
                }
                case 12: {
                    this.dealerValue = this.dealerHand.nextCard();
                    if (this.dealerValue != 0 && this.dealerValue < 17) break;
                    this.handControl = 13;
                    break;
                }
                case 13: {
                    this.delay = 3;
                    this.handControl = 14;
                    this.hands.determineResults(this.dealerValue);
                    break;
                }
                case 14: {
                    --this.delay;
                    if (this.delay != 0) break;
                    this.handControl = 15;
                    break;
                }
                case 15: {
                    this.dealerHand.clear();
                    this.hands.clear();
                    this.update(this.getGraphics());
                    if (this.deck.getNeedsShuffled()) {
                        this.deck.shuffle();
                        this.deck.setVisible(false);
                        this.ShufflingLabel.setVisible(true);
                        this.handControl = 16;
                        this.delay = 3;
                    } else {
                        this.handControl = 0;
                        this.pause = 1;
                    }
                    this.optionsEnabled = true;
                    this.OptionsButton.setLabel("Options");
                    break;
                }
                case 16: {
                    --this.delay;
                    if (this.delay != 0) break;
                    this.ShufflingLabel.setVisible(false);
                    this.deck.setVisible(true);
                    this.handControl = 0;
                    this.pause = 1;
                }
            }
            try {
                Thread.sleep(this.pause);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String convertToDollarString(int n) {
        if (n < 0) {
            n = -n;
        }
        String string = new String("$" + String.valueOf(n / 2));
        string = n % 2 == 0 ? String.valueOf(string) + ".00" : String.valueOf(string) + ".50";
        return string;
    }

    private void setPlacard() {
        Color color;
        if (this.bjOptions.limitIndex == 0) {
            color = new Color(128, 128, 128);
            this.placard.setBackground(color);
            this.minLabel.setBackground(color);
            this.maxLabel.setBackground(color);
            this.doubleLabel.setBackground(color);
            this.DASLabel.setBackground(color);
            this.resplitLabel.setBackground(color);
            this.surrenderLabel.setBackground(color);
        }
        if (this.bjOptions.limitIndex == 1) {
            color = new Color(128, 0, 0);
            this.placard.setBackground(color);
            this.minLabel.setBackground(color);
            this.maxLabel.setBackground(color);
            this.doubleLabel.setBackground(color);
            this.DASLabel.setBackground(color);
            this.resplitLabel.setBackground(color);
            this.surrenderLabel.setBackground(color);
            this.placard.repaint();
        }
        if (this.bjOptions.limitIndex == 2) {
            color = new Color(0, 128, 0);
            this.placard.setBackground(color);
            this.minLabel.setBackground(color);
            this.maxLabel.setBackground(color);
            this.doubleLabel.setBackground(color);
            this.DASLabel.setBackground(color);
            this.resplitLabel.setBackground(color);
            this.surrenderLabel.setBackground(color);
        }
        if (this.bjOptions.limitIndex == 3) {
            color = Color.black;
            this.placard.setBackground(color);
            this.minLabel.setBackground(color);
            this.maxLabel.setBackground(color);
            this.doubleLabel.setBackground(color);
            this.DASLabel.setBackground(color);
            this.resplitLabel.setBackground(color);
            this.surrenderLabel.setBackground(color);
        }
        int n = this.play2HandsCheck.getState() ? this.bjOptions.getMinBet() / 2 : this.bjOptions.getMinBet();
        this.minLabel.setText("Min:  " + String.valueOf(n));
        this.maxLabel.setText("Max:  " + String.valueOf(this.bjOptions.getMaxBet()));
        if (this.bjOptions.doubleOn_10_or_11_only) {
            this.doubleLabel.setText("Double On 10 or 11 Only");
        } else {
            this.doubleLabel.setText("Double on Any Two Cards");
        }
        if (this.bjOptions.doubleAfterSplitAllowed) {
            this.DASLabel.setText("Double After Split");
        } else {
            this.DASLabel.setText("No Double After Split");
        }
        if (this.bjOptions.resplitPairsAllowed) {
            if (this.bjOptions.resplitAcesAllowed) {
                this.resplitLabel.setText("Resplit Aces and Pairs");
            } else {
                this.resplitLabel.setText("Resplit Pairs, Except Aces");
            }
        } else if (this.bjOptions.resplitAcesAllowed) {
            this.resplitLabel.setText("Resplit Aces Only");
        } else {
            this.resplitLabel.setText("No Respliting");
        }
        if (this.bjOptions.surrenderAllowed) {
            this.surrenderLabel.setText("Late Surrender Allowed");
            return;
        }
        this.surrenderLabel.setText("No Surrender");
    }

    private void buyChips() {
        int n = 1;
        while (n <= 9) {
            this.baseStack.buyChips(100);
            ++n;
        }
        this.baseStack.removeChips(5);
        this.baseStack.addChips(5);
        this.baseStack.buyChips(100);
        this.bank.addToBank(-100000);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.paint(graphics);
        if (this.isVisible()) {
            String string = new String();
            string = this.bjOptions.hitSoft17 ? "Dealer Must Hit Soft 17" : "Dealer Must Stand On All 17's";
            graphics.setColor(Color.black);
            graphics.setFont(new Font("SansSerif", 1, 24));
            int n = (700 - graphics.getFontMetrics().stringWidth(string)) / 2;
            graphics.drawString(string, n, 140);
            graphics.fillRect(this.getInsets().left, 145, 700, 4);
            graphics.fillRect(this.getInsets().left, 170, 700, 4);
            string = "Insurance Pays 2 to 1";
            n = (700 - graphics.getFontMetrics().stringWidth(string)) / 2;
            graphics.drawString(string, n, 168);
            if (this.hands != null) {
                this.hands.paintInsuranceBet(graphics);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.OptionsButton) {
            this.OptionsButton_actionPerformed(actionEvent);
            return;
        }
        if (object == this.HelpButton) {
            this.HelpButton_actionPerformed(actionEvent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.dealerHand.setShowTotal(this.showTotalCheck.getState());
        this.hands.setShowTotal(this.showTotalCheck.getState());
    }

    void OptionsButton_actionPerformed(ActionEvent actionEvent) {
        if (this.optionsEnabled) {
            this.OptionsButton.setEnabled(false);
            new OptionsDlg((Frame)this, "Options", true, this.bjOptions).setVisible(true);
            if (this.bjOptions.isChanged()) {
                this.deck.reset(this.bjOptions.numberDecks, this.bjOptions.penetration);
                this.ShufflingLabel.setVisible(true);
                this.pause = 300;
                this.handControl = 16;
                this.delay = 3;
                this.deck.setVisible(false);
                this.setPlacard();
            }
            this.OptionsButton.setEnabled(true);
            return;
        }
        new BasicStrategyChart(this, "Strategy", this.bjOptions, this.bjOptions.doubleOn_10_or_11_only, this.bjOptions.doubleAfterSplitAllowed, this.bjOptions.surrenderAllowed, this.bjOptions.numberDecks != 1).setVisible(true);
    }

    void HelpButton_actionPerformed(ActionEvent actionEvent) {
        new HelpFrame((Frame)this, "Help").setVisible(true);
    }

    void Blackjack_WindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void addToBank(int n) {
        int n2 = this.baseStack.getChipsBought() * 2;
        int n3 = this.baseStack.countHalfChips();
        int n4 = n3 - n2;
        this.chipsBoughtAmountLabel.setText(this.convertToDollarString(n2));
        this.chipsOnhandAmountLabel.setText(this.convertToDollarString(n3));
        this.netAmountLabel.setText(this.convertToDollarString(n4));
        if (n4 < 0) {
            this.netLabel.setText("Losing");
        } else {
            this.netLabel.setText("Winning");
        }
        this.bank.addToBank(n * 50);
    }

    public void finalize() throws Throwable {
        super.finalize();
        try {
            this.t.join();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    class SymWindow
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == Blackjack.this) {
                Blackjack.this.Blackjack_WindowClosing(windowEvent);
            }
        }

        SymWindow() {
        }
    }
}

