/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;

public class CardPanel
extends Panel
implements ImageObserver {
    public static final int CARDHEIGHT = 96;
    public static final int CARDWIDTH = 71;
    public static final int FRONT = 1;
    public static final int BACK = 2;
    public static final int HIDE = 3;
    private static final int rankLeft = 1;
    private static final int rankTop = 4;
    private static final int rankHeight = 14;
    private static final short[][] rankPixels;
    private static final int suitLeft = 1;
    private static final int suitTop = 18;
    private static final int suitHeight = 10;
    private static final short[][] suitPixels;
    private static final int faceWidth = 47;
    private static final int faceHeight = 37;
    private static final int faceLeft = 12;
    private static final int faceTop = 11;
    private static final byte[][] pipsLeft;
    private static final byte[][] pipsTop;
    private static final int pipHeight = 15;
    private static final int[][] pipPixels;
    private static final int wildMarkHeight = 35;
    private static final short[] wildMark;
    private static final int wildMarkXOffset = 54;
    private static final int wildMarkYOffset = 2;
    private Card card;
    private int cardWidth;
    private int cardHeight;
    private int status;
    private Image cardImage;
    private Graphics cardGraphics;
    private boolean cardBackImageLoaded;
    private boolean wild = false;
    private boolean sideways;
    private static Image facesImage;
    private static Image cardBack;
    private static Image jokerImage;

    public CardPanel(int n, int n2, Card card, int n3, boolean bl) {
        this(n, n2, card, n3);
        this.sideways = bl;
        if (this.sideways) {
            this.setSize(96, 71);
        }
    }

    public CardPanel(int n, int n2, Card card, int n3) {
        this.setLocation(n, n2);
        this.cardWidth = 71;
        this.cardHeight = 96;
        this.setSize(this.cardWidth, this.cardHeight);
        this.card = card;
        this.status = n3;
        this.setVisible(false);
    }

    public void addNotify() {
        super.addNotify();
        this.cardImage = this.createImage(this.cardWidth, this.cardHeight);
        if (this.status == 3) {
            this.setVisible(false);
        }
        if (this.status == 1) {
            this.showFront();
        }
        if (this.status == 2) {
            this.showBack();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.cardImage = null;
    }

    public static void setCardsImage(Image image, Image image2, Image image3) {
        facesImage = image;
        cardBack = image2;
        jokerImage = image3;
    }

    public Card getCard() {
        return this.card;
    }

    public void setCard(Card card) {
        this.card.setCard(card.getRank(), card.getSuit());
        if (this.status == 3) {
            this.setVisible(false);
        }
        if (this.status == 1) {
            this.showFront();
        }
        if (this.status == 2) {
            this.showBack();
        }
    }

    public void showFront() {
        if (this.card.isJoker()) {
            this.drawJoker();
        } else {
            if (this.cardImage == null) {
                return;
            }
            this.cardGraphics = this.cardImage.getGraphics();
            this.drawBackground();
            this.drawBorder();
            this.drawRank();
            this.drawSuit();
            if (this.card.getRank() > 10) {
                this.drawFace();
            } else {
                this.drawPips();
            }
            if (this.wild) {
                this.drawWild();
            }
        }
        this.setVisible(true);
        this.status = 1;
        this.cardGraphics = null;
        this.update(this.getGraphics());
    }

    public void markWild() {
        this.wild = true;
        if (this.status == 1) {
            this.showFront();
        }
    }

    public void unMarkWild() {
        this.wild = false;
        if (this.status == 1) {
            this.showFront();
        }
    }

    private void drawBackground() {
        this.cardGraphics.setColor(Color.white);
        this.cardGraphics.fillRect(0, 0, this.cardWidth - 1, this.cardHeight - 1);
    }

    private void drawBorder() {
        this.cardGraphics.setColor(Color.black);
        this.cardGraphics.drawRect(0, 0, this.cardWidth - 1, this.cardHeight - 1);
    }

    private void drawRank() {
        this.cardGraphics.setColor(this.card.getSuit() == 4 || this.card.getSuit() == 1 ? Color.black : Color.red);
        int n = 0;
        while (n < 14) {
            int n2 = 15;
            while (n2 >= 0) {
                if ((1 << n2 & rankPixels[this.card.getRank() - 1][n]) != 0) {
                    int n3 = 16 - n2;
                    int n4 = 4 + n;
                    this.cardGraphics.drawLine(n3, n4, n3, n4);
                    int n5 = 70 - n3;
                    int n6 = 95 - n4;
                    this.cardGraphics.drawLine(n5, n6, n5, n6);
                }
                --n2;
            }
            ++n;
        }
    }

    private void drawSuit() {
        this.cardGraphics.setColor(this.card.getSuit() == 4 || this.card.getSuit() == 1 ? Color.black : Color.red);
        int n = 0;
        while (n < 10) {
            int n2 = 15;
            while (n2 >= 0) {
                if ((1 << n2 & suitPixels[this.card.getSuit() - 1][n]) != 0) {
                    int n3 = 16 - n2;
                    int n4 = 18 + n;
                    this.cardGraphics.drawLine(n3, n4, n3, n4);
                    int n5 = 70 - n3;
                    int n6 = 95 - n4;
                    this.cardGraphics.drawLine(n5, n6, n5, n6);
                }
                --n2;
            }
            ++n;
        }
    }

    private synchronized void drawFace() {
        if (!this.cardGraphics.drawImage(facesImage, 12, 11, 59, 48, 47 * (this.card.getRank() - 11), 37 * (this.card.getSuit() - 1), 47 * (this.card.getRank() - 11 + 1), 37 * this.card.getSuit(), this)) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.cardGraphics.drawImage(facesImage, this.cardWidth - 59, this.cardHeight - 48, this.cardWidth - 12, this.cardHeight - 11, 47 * (this.card.getRank() - 11 + 1), 37 * this.card.getSuit(), 47 * (this.card.getRank() - 11), 37 * (this.card.getSuit() - 1), this)) {
            try {
                this.wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private void drawPips() {
        int n = 0;
        while (n < 10) {
            if (pipsLeft[this.card.getRank() - 1][n] != 0) {
                if (n < 5) {
                    this.drawOnePip(pipsLeft[this.card.getRank() - 1][n], pipsTop[this.card.getRank() - 1][n]);
                } else {
                    this.drawOnePipUpsidedown(pipsLeft[this.card.getRank() - 1][n], pipsTop[this.card.getRank() - 1][n]);
                }
            }
            ++n;
        }
    }

    private void drawOnePip(int n, int n2) {
        this.cardGraphics.setColor(this.card.getSuit() == 4 || this.card.getSuit() == 1 ? Color.black : Color.red);
        int n3 = 0;
        while (n3 < 15) {
            int n4 = 15;
            while (n4 >= 0) {
                if ((1 << n4 & pipPixels[this.card.getSuit() - 1][n3]) != 0) {
                    int n5 = n + 15 - n4;
                    int n6 = n2 + n3;
                    this.cardGraphics.drawLine(n5, n6, n5, n6);
                }
                --n4;
            }
            ++n3;
        }
    }

    private void drawOnePipUpsidedown(int n, int n2) {
        this.cardGraphics.setColor(this.card.getSuit() == 4 || this.card.getSuit() == 1 ? Color.black : Color.red);
        int n3 = 0;
        while (n3 < 15) {
            int n4 = 15;
            while (n4 >= 0) {
                if ((1 << n4 & pipPixels[this.card.getSuit() - 1][n3]) != 0) {
                    int n5 = 71 - (n + 15 - n4);
                    int n6 = 96 - (n2 + n3);
                    this.cardGraphics.drawLine(n5, n6, n5, n6);
                }
                --n4;
            }
            ++n3;
        }
    }

    private void drawCardPixel(int n, int n2) {
        this.cardGraphics.drawLine(n, n2, n, n2);
    }

    private Color getCardColor() {
        if (this.card.getSuit() == 4 || this.card.getSuit() == 1) {
            return Color.black;
        }
        return Color.red;
    }

    private void drawWild() {
        this.cardGraphics.setColor(Color.red);
        int n = 0;
        while (n < 35) {
            int n2 = 15;
            while (n2 >= 0) {
                if ((1 << n2 & wildMark[n]) != 0) {
                    int n3 = 69 - n2;
                    int n4 = 2 + n;
                    this.cardGraphics.drawLine(n3, n4, n3, n4);
                    n3 = this.cardWidth - 1 - (69 - n2);
                    n4 = this.cardHeight - 1 - (2 + n);
                    this.cardGraphics.drawLine(n3, n4, n3, n4);
                }
                --n2;
            }
            ++n;
        }
    }

    public void showBack() {
        if (this.cardImage == null) {
            return;
        }
        this.cardBackImageLoaded = this.cardImage.getGraphics().drawImage(cardBack, 0, 0, this);
        if (!this.cardBackImageLoaded) {
            this.drawDefaultCardBack();
        }
        this.setVisible(true);
        this.status = 2;
        this.update(this.getGraphics());
    }

    private void drawDefaultCardBack() {
        Graphics graphics = this.cardImage.getGraphics();
        graphics.setColor(new Color(128, 0, 0));
        graphics.fillRect(0, 0, this.cardWidth, this.cardHeight);
    }

    private synchronized void drawJoker() {
        boolean bl;
        if (this.cardImage == null) {
            return;
        }
        boolean bl2 = bl = !this.cardImage.getGraphics().drawImage(jokerImage, 0, 0, this);
        if (bl) {
            try {
                this.wait();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void hideCard() {
        this.cardImage = null;
        this.setVisible(false);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.sideways) {
            graphics.drawImage(this.createImage(new FilteredImageSource(this.cardImage.getSource(), new RotateImageFilter())), 0, 0, this);
            return;
        }
        graphics.drawImage(this.cardImage, 0, 0, this);
    }

    public void setX(int n) {
        this.setLocation(n, this.getY());
    }

    public void setY(int n) {
        this.setLocation(this.getX(), n);
    }

    public int getX() {
        return this.getLocation().x;
    }

    public int getY() {
        return this.getLocation().y;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            if (image == jokerImage) {
                this.cardImage.getGraphics().drawImage(jokerImage, 0, 0, null);
                this.notifyAll();
                return false;
            }
            if (image == facesImage) {
                this.cardGraphics.drawImage(facesImage, 12, 11, 59, 48, 47 * (this.card.getRank() - 11), 37 * (this.card.getSuit() - 1), 47 * (this.card.getRank() - 11 + 1), 37 * this.card.getSuit(), null);
                this.cardGraphics.drawImage(facesImage, this.cardWidth - 12 - 47, this.cardHeight - 11 - 37, this.cardWidth - 12, this.cardHeight - 11, 47 * (this.card.getRank() - 11 + 1), 37 * this.card.getSuit(), 47 * (this.card.getRank() - 11), 37 * (this.card.getSuit() - 1), null);
                this.notifyAll();
                return false;
            }
            if (image == cardBack) {
                this.cardImage.getGraphics().drawImage(cardBack, 0, 0, null);
                this.cardBackImageLoaded = true;
                this.notifyAll();
                return false;
            }
            this.update(this.getGraphics());
            return false;
        }
        if ((n & 0xC0) != 0) {
            this.notifyAll();
            return false;
        }
        return true;
    }

    static {
        short[][] sArrayArray = new short[13][];
        short[] sArray = new short[14];
        sArray[0] = 512;
        sArray[1] = 512;
        sArray[2] = 1792;
        sArray[3] = 1792;
        sArray[4] = 3456;
        sArray[5] = 3456;
        sArray[6] = 3456;
        sArray[7] = 8128;
        sArray[8] = 16352;
        sArray[9] = 12384;
        sArray[10] = 30960;
        sArray[11] = 30960;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[14];
        sArray2[0] = 3968;
        sArray2[1] = 8128;
        sArray2[2] = 6336;
        sArray2[3] = 192;
        sArray2[4] = 448;
        sArray2[5] = 896;
        sArray2[6] = 1792;
        sArray2[7] = 3584;
        sArray2[8] = 7360;
        sArray2[9] = 6336;
        sArray2[10] = 8128;
        sArray2[11] = 8128;
        sArrayArray[1] = sArray2;
        short[] sArray3 = new short[14];
        sArray3[0] = 8128;
        sArray3[1] = 8128;
        sArray3[2] = 6528;
        sArray3[3] = 768;
        sArray3[4] = 1536;
        sArray3[5] = 3968;
        sArray3[6] = 4032;
        sArray3[7] = 192;
        sArray3[8] = 192;
        sArray3[9] = 6336;
        sArray3[10] = 8128;
        sArray3[11] = 3968;
        sArrayArray[2] = sArray3;
        short[] sArray4 = new short[14];
        sArray4[0] = 384;
        sArray4[1] = 896;
        sArray4[2] = 1920;
        sArray4[3] = 3968;
        sArray4[4] = 7552;
        sArray4[5] = 14720;
        sArray4[6] = 16352;
        sArray4[7] = 16352;
        sArray4[8] = 384;
        sArray4[9] = 384;
        sArray4[10] = 960;
        sArray4[11] = 960;
        sArrayArray[3] = sArray4;
        short[] sArray5 = new short[14];
        sArray5[0] = 8128;
        sArray5[1] = 8128;
        sArray5[2] = 6144;
        sArray5[3] = 6144;
        sArray5[4] = 8064;
        sArray5[5] = 8128;
        sArray5[6] = 192;
        sArray5[7] = 192;
        sArray5[8] = 6336;
        sArray5[9] = 6336;
        sArray5[10] = 8128;
        sArray5[11] = 3968;
        sArrayArray[4] = sArray5;
        short[] sArray6 = new short[14];
        sArray6[0] = 1920;
        sArray6[1] = 3968;
        sArray6[2] = 7168;
        sArray6[3] = 6144;
        sArray6[4] = 8064;
        sArray6[5] = 8128;
        sArray6[6] = 6336;
        sArray6[7] = 6336;
        sArray6[8] = 6336;
        sArray6[9] = 6336;
        sArray6[10] = 8128;
        sArray6[11] = 3968;
        sArrayArray[5] = sArray6;
        short[] sArray7 = new short[14];
        sArray7[0] = 8128;
        sArray7[1] = 8128;
        sArray7[2] = 6336;
        sArray7[3] = 384;
        sArray7[4] = 384;
        sArray7[5] = 768;
        sArray7[6] = 768;
        sArray7[7] = 768;
        sArray7[8] = 1536;
        sArray7[9] = 1536;
        sArray7[10] = 1536;
        sArray7[11] = 1536;
        sArrayArray[6] = sArray7;
        short[] sArray8 = new short[14];
        sArray8[0] = 3968;
        sArray8[1] = 8128;
        sArray8[2] = 6336;
        sArray8[3] = 6336;
        sArray8[4] = 6336;
        sArray8[5] = 3968;
        sArray8[6] = 8128;
        sArray8[7] = 6336;
        sArray8[8] = 6336;
        sArray8[9] = 6336;
        sArray8[10] = 8128;
        sArray8[11] = 3968;
        sArrayArray[7] = sArray8;
        short[] sArray9 = new short[14];
        sArray9[0] = 3968;
        sArray9[1] = 8128;
        sArray9[2] = 6336;
        sArray9[3] = 6336;
        sArray9[4] = 6336;
        sArray9[5] = 6336;
        sArray9[6] = 8128;
        sArray9[7] = 4032;
        sArray9[8] = 192;
        sArray9[9] = 448;
        sArray9[10] = 3968;
        sArray9[11] = 3840;
        sArrayArray[8] = sArray9;
        short[] sArray10 = new short[14];
        sArray10[0] = 13248;
        sArray10[1] = 14304;
        sArray10[2] = 13920;
        sArray10[3] = 13920;
        sArray10[4] = 13920;
        sArray10[5] = 13920;
        sArray10[6] = 13920;
        sArray10[7] = 13920;
        sArray10[8] = 13920;
        sArray10[9] = 13920;
        sArray10[10] = 14304;
        sArray10[11] = 13248;
        sArrayArray[9] = sArray10;
        short[] sArray11 = new short[14];
        sArray11[0] = 1920;
        sArray11[1] = 1920;
        sArray11[2] = 768;
        sArray11[3] = 768;
        sArray11[4] = 768;
        sArray11[5] = 768;
        sArray11[6] = 768;
        sArray11[7] = 768;
        sArray11[8] = 13056;
        sArray11[9] = 13056;
        sArray11[10] = 16128;
        sArray11[11] = 7680;
        sArrayArray[10] = sArray11;
        sArrayArray[11] = new short[]{7936, 16256, 12672, 12672, 12672, 12672, 12672, 12672, 12672, 12672, 16256, 7936, 896, 384};
        short[] sArray12 = new short[14];
        sArray12[0] = 31680;
        sArray12[1] = 31680;
        sArray12[2] = 13056;
        sArray12[3] = 13824;
        sArray12[4] = 15360;
        sArray12[5] = 14336;
        sArray12[6] = 15360;
        sArray12[7] = 13824;
        sArray12[8] = 13056;
        sArray12[9] = 12672;
        sArray12[10] = 31680;
        sArray12[11] = 31680;
        sArrayArray[12] = sArray12;
        rankPixels = sArrayArray;
        short[][] sArrayArray2 = new short[4][];
        sArrayArray2[0] = new short[]{3584, 7936, 7936, 11904, 32704, 32704, 32704, 13696, 1024, 3584};
        short[] sArray13 = new short[10];
        sArray13[0] = 1024;
        sArray13[1] = 3584;
        sArray13[2] = 7936;
        sArray13[3] = 16256;
        sArray13[4] = 16256;
        sArray13[5] = 16256;
        sArray13[6] = 7936;
        sArray13[7] = 3584;
        sArray13[8] = 1024;
        sArrayArray2[1] = sArray13;
        short[] sArray14 = new short[10];
        sArray14[1] = 15232;
        sArray14[2] = 31680;
        sArray14[3] = 32704;
        sArray14[4] = 32704;
        sArray14[5] = 32704;
        sArray14[6] = 16256;
        sArray14[7] = 7936;
        sArray14[8] = 3584;
        sArray14[9] = 1024;
        sArrayArray2[2] = sArray14;
        sArrayArray2[3] = new short[]{1024, 3584, 7936, 16256, 32704, 32704, 32704, 13696, 3584, 3584};
        suitPixels = sArrayArray2;
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[10];
        byArray[0] = 28;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = 28;
        byArray2[5] = 28;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[10];
        byArray3[0] = 28;
        byArray3[1] = 28;
        byArray3[5] = 28;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[10];
        byArray4[0] = 16;
        byArray4[1] = 41;
        byArray4[5] = 16;
        byArray4[6] = 41;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[10];
        byArray5[0] = 16;
        byArray5[1] = 41;
        byArray5[2] = 28;
        byArray5[5] = 16;
        byArray5[6] = 41;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[10];
        byArray6[0] = 16;
        byArray6[1] = 41;
        byArray6[2] = 16;
        byArray6[3] = 41;
        byArray6[5] = 16;
        byArray6[6] = 41;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[10];
        byArray7[0] = 16;
        byArray7[1] = 41;
        byArray7[2] = 16;
        byArray7[3] = 41;
        byArray7[4] = 28;
        byArray7[5] = 16;
        byArray7[6] = 41;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[10];
        byArray8[0] = 16;
        byArray8[1] = 41;
        byArray8[2] = 16;
        byArray8[3] = 41;
        byArray8[5] = 16;
        byArray8[6] = 41;
        byArray8[7] = 16;
        byArray8[8] = 41;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[10];
        byArray9[0] = 16;
        byArray9[1] = 41;
        byArray9[2] = 16;
        byArray9[3] = 41;
        byArray9[4] = 28;
        byArray9[5] = 16;
        byArray9[6] = 41;
        byArray9[7] = 16;
        byArray9[8] = 41;
        byArrayArray[8] = byArray9;
        byArrayArray[9] = new byte[]{16, 41, 16, 41, 28, 16, 41, 16, 41, 28};
        pipsLeft = byArrayArray;
        byte[][] byArrayArray2 = new byte[10][];
        byte[] byArray10 = new byte[10];
        byArray10[0] = 41;
        byArrayArray2[0] = byArray10;
        byte[] byArray11 = new byte[10];
        byArray11[0] = 10;
        byArray11[5] = 10;
        byArrayArray2[1] = byArray11;
        byte[] byArray12 = new byte[10];
        byArray12[0] = 10;
        byArray12[1] = 41;
        byArray12[5] = 10;
        byArrayArray2[2] = byArray12;
        byte[] byArray13 = new byte[10];
        byArray13[0] = 10;
        byArray13[1] = 10;
        byArray13[5] = 10;
        byArray13[6] = 10;
        byArrayArray2[3] = byArray13;
        byte[] byArray14 = new byte[10];
        byArray14[0] = 10;
        byArray14[1] = 10;
        byArray14[2] = 41;
        byArray14[5] = 10;
        byArray14[6] = 10;
        byArrayArray2[4] = byArray14;
        byte[] byArray15 = new byte[10];
        byArray15[0] = 10;
        byArray15[1] = 10;
        byArray15[2] = 41;
        byArray15[3] = 41;
        byArray15[5] = 10;
        byArray15[6] = 10;
        byArrayArray2[5] = byArray15;
        byte[] byArray16 = new byte[10];
        byArray16[0] = 10;
        byArray16[1] = 10;
        byArray16[2] = 41;
        byArray16[3] = 41;
        byArray16[4] = 27;
        byArray16[5] = 10;
        byArray16[6] = 10;
        byArrayArray2[6] = byArray16;
        byte[] byArray17 = new byte[10];
        byArray17[0] = 10;
        byArray17[1] = 10;
        byArray17[2] = 31;
        byArray17[3] = 31;
        byArray17[5] = 10;
        byArray17[6] = 10;
        byArray17[7] = 31;
        byArray17[8] = 31;
        byArrayArray2[7] = byArray17;
        byte[] byArray18 = new byte[10];
        byArray18[0] = 10;
        byArray18[1] = 10;
        byArray18[2] = 30;
        byArray18[3] = 30;
        byArray18[4] = 40;
        byArray18[5] = 10;
        byArray18[6] = 10;
        byArray18[7] = 30;
        byArray18[8] = 30;
        byArrayArray2[8] = byArray18;
        byArrayArray2[9] = new byte[]{10, 10, 31, 31, 21, 10, 10, 31, 31, 21};
        pipsTop = byArrayArray2;
        pipPixels = new int[][]{{896, 1984, 4064, 4064, 4064, 1984, 15288, 32764, 65534, 65534, 65534, 32124, 14648, 896, 1984}, {256, 896, 1984, 4064, 8176, 8176, 16376, 32764, 16376, 8176, 8176, 4064, 1984, 896, 256}, {15480, 32508, 65278, 65534, 65534, 65534, 65534, 32764, 32764, 16376, 8176, 4064, 1984, 896, 256}, {256, 896, 1984, 4064, 8176, 16376, 32764, 32764, 65534, 65534, 65534, 64894, 31036, 896, 1984}};
        short[] sArray15 = new short[35];
        sArray15[0] = 15934;
        sArray15[1] = 7218;
        sArray15[2] = 3698;
        sArray15[3] = 3708;
        sArray15[4] = 1980;
        sArray15[5] = 1848;
        sArray15[6] = 528;
        sArray15[7] = 528;
        sArray15[9] = 992;
        sArray15[10] = 384;
        sArray15[11] = 384;
        sArray15[12] = 384;
        sArray15[13] = 384;
        sArray15[14] = 384;
        sArray15[15] = 384;
        sArray15[16] = 992;
        sArray15[18] = 1984;
        sArray15[19] = 896;
        sArray15[20] = 896;
        sArray15[21] = 952;
        sArray15[22] = 932;
        sArray15[23] = 932;
        sArray15[24] = 908;
        sArray15[25] = 2040;
        sArray15[27] = 2016;
        sArray15[28] = 920;
        sArray15[29] = 904;
        sArray15[30] = 900;
        sArray15[31] = 900;
        sArray15[32] = 900;
        sArray15[33] = 908;
        sArray15[34] = 2040;
        wildMark = sArray15;
    }
}

