/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

public class ChipStack
extends Panel {
    final int stackWidth = 38;
    final int maxChips = 20;
    final int maxOffset = 4;
    final int offset = 0;
    final int lineStart = 1;
    final int chipWidth = 28;
    final int chipHeightConst = 6;
    final int topDiff = 0;
    final int leftDiff = 41;
    ChipStack nextHigher;
    int higherRatio;
    int dropLevel;
    int numberOfChips;
    byte[] chipsOffset;
    byte[] chipsLines;
    protected int chipHeight;
    Color lineColor;
    Color chipColor;
    int overflow;
    protected int chipValue;
    String text;
    boolean tempStack;

    public ChipStack() {
    }

    public ChipStack(Color color, Color color2, int n, String string, int n2, int n3) {
        this.setBackground(new Color(0, 128, 0));
        this.nextHigher = null;
        this.higherRatio = 1;
        this.dropLevel = n < 20 ? n : 20;
        this.chipColor = color;
        this.lineColor = color2;
        this.numberOfChips = 0;
        this.chipHeight = 6;
        this.text = string;
        int n4 = (this.dropLevel - 1) * this.chipHeight + 15;
        this.setLocation(n2, n3 - n4);
        this.setSize(38, n4);
        this.tempStack = false;
        this.chipsOffset = new byte[this.dropLevel];
        this.chipsLines = new byte[this.dropLevel];
        int n5 = 1;
        while (n5 < this.dropLevel) {
            this.chipsOffset[n5] = (byte)(4.0 * Math.random() + 1.0);
            this.chipsLines[n5] = (byte)(20.0 * Math.random() + 3.0);
            ++n5;
        }
    }

    private void addChip() {
        ++this.numberOfChips;
        if (this.numberOfChips == this.dropLevel) {
            --this.numberOfChips;
            if (this.nextHigher == null) {
                this.nextHigher = new ChipStack(this.chipColor, this.lineColor, this.dropLevel, "", this.getLeft() + 41, this.getTop() + this.getHeight());
                this.getParent().add(this.nextHigher);
                this.nextHigher.tempStack = true;
            }
            int n = 1;
            while (n <= this.higherRatio - 1) {
                this.getChip();
                ++n;
            }
            this.nextHigher.addChip();
            return;
        }
        this.chipsOffset[this.numberOfChips] = (byte)(4.0 * Math.random());
        this.chipsLines[this.numberOfChips] = (byte)(20.0 * Math.random() + 3.0);
        this.drawChip(this.numberOfChips, this.getGraphics());
    }

    private int getChip() {
        if (this.overflow != 0) {
            --this.overflow;
            return 1;
        }
        if (this.numberOfChips == 0) {
            if (this.nextHigher == null) {
                return 0;
            }
            if (this.nextHigher.removeChips(1) != 1) {
                int n = 1;
                while (n <= this.higherRatio - 1) {
                    this.addChip();
                    ++n;
                }
                return 1;
            }
            return 0;
        }
        --this.numberOfChips;
        this.clearChip(this.numberOfChips + 1, this.getGraphics());
        return 1;
    }

    public void setChipValue(int n) {
        this.chipValue = n;
        if (this.nextHigher != null) {
            this.nextHigher.setChipValue(n * this.higherRatio);
        }
    }

    private void drawChip(int n, Graphics graphics) {
        if (n == 1) {
            graphics.setColor(new Color(0, 128, 0));
            graphics.fillRect(0, (this.dropLevel - n - 1) * this.chipHeight, 38, this.chipHeight);
        }
        this.drawChip2(graphics, (this.dropLevel - n - 1) * this.chipHeight, this.chipsOffset[n], this.chipsLines[n]);
    }

    private void clearChip(int n, Graphics graphics) {
        graphics.setColor(new Color(0, 128, 0));
        graphics.fillRect(0, (this.dropLevel - n - 1) * this.chipHeight, 38, this.chipHeight);
        if (n == 1 && !this.tempStack) {
            this.drawBlank(graphics);
        }
    }

    protected void drawChip2(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.chipColor);
        graphics.fillRect(n2, n, 28, this.chipHeight - 1);
        graphics.setColor(Color.black);
        graphics.drawRect(n2, n, 28, this.chipHeight - 1);
        graphics.setColor(this.lineColor);
        graphics.drawLine(n2 + n3, n + 1, n2 + n3, n + this.chipHeight - 2);
        graphics.drawLine(n2 + n3 + 2, n + 1, n2 + n3 + 2, n + this.chipHeight - 2);
        graphics.drawLine(n2 + n3 + 4, n + 1, n2 + n3 + 4, n + this.chipHeight - 2);
    }

    private void setText(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setFont(new Font(graphics.getFont().getName(), 0, 10));
        graphics.drawString(this.text, 3, this.dropLevel * this.chipHeight + 8);
    }

    private void growStack() {
        this.drawChip(this.numberOfChips, this.getGraphics());
    }

    private void shrinkStack() {
        this.clearChip(this.numberOfChips + 1, this.getGraphics());
    }

    private void makeChange() {
        if (this.nextHigher != null && this.nextHigher.removeChips(1) != 1) {
            int n = 1;
            while (n <= this.higherRatio) {
                this.addChip();
                ++n;
            }
        }
    }

    protected void drawBlank(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawRect(2, (this.dropLevel - 2) * this.chipHeight, 28, this.chipHeight - 1);
    }

    public int DrawOnBox(int n, int n2, int n3, Graphics graphics) {
        int n4 = this.nextHigher != null ? n % this.higherRatio : n;
        int n5 = 1;
        while (n5 <= n4) {
            this.drawChip2(graphics, n2, n3 + this.chipsOffset[(n4 - n5) % (this.dropLevel - 1) + 1], this.chipsLines[(n4 - n5) % (this.dropLevel - 1) + 1]);
            n2 += this.chipHeight;
            ++n5;
        }
        if (this.nextHigher != null) {
            n2 = this.nextHigher.DrawOnBox(n / this.higherRatio, n2, n3, graphics);
        }
        return n2;
    }

    public int getStackHeight(int n) {
        int n2;
        if (this.nextHigher != null) {
            n2 = this.nextHigher.getStackHeight(n / this.higherRatio);
            n2 += n % this.higherRatio * this.chipHeight;
        } else {
            n2 = n * this.chipHeight;
        }
        return n2;
    }

    public int countChips() {
        if (this.nextHigher != null) {
            return this.numberOfChips + this.nextHigher.countChips() * this.higherRatio;
        }
        return this.numberOfChips + this.overflow;
    }

    public void addChips(int n) {
        if (this.nextHigher != null & this.higherRatio != 1) {
            this.nextHigher.addChips(n / this.higherRatio);
            int n2 = 1;
            while (n2 <= n % this.higherRatio) {
                this.addChip();
                ++n2;
            }
            return;
        }
        int n3 = 1;
        while (n3 <= n) {
            this.addChip();
            ++n3;
        }
    }

    public int removeChips(int n) {
        if (this.nextHigher != null) {
            n = this.nextHigher.removeChips(n / this.higherRatio) * this.higherRatio + n % this.higherRatio;
        }
        while (this.countChips() > 0 & n > 0) {
            this.getChip();
            --n;
        }
        return n;
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.paint(graphics);
        if (this.numberOfChips == 0) {
            if (this.tempStack) {
                return;
            }
            this.drawBlank(graphics);
        } else {
            int n = 1;
            while (n <= this.numberOfChips) {
                this.drawChip(n, graphics);
                ++n;
            }
        }
        this.setText(graphics);
    }

    public int getChipValue() {
        return this.chipValue;
    }

    public int getchipHeight() {
        return this.chipHeight;
    }

    public void setHigher(ChipStack chipStack, int n) {
        this.nextHigher = chipStack;
        if (this.nextHigher != null) {
            this.higherRatio = n;
            return;
        }
        this.higherRatio = 1;
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    protected int getLeft() {
        return this.getLocation().x;
    }

    protected int getTop() {
        return this.getLocation().y;
    }

    protected void setLeft(int n) {
        this.setLocation(n, this.getTop());
    }

    protected void setTop(int n) {
        this.setLocation(this.getLeft(), n);
    }

    protected void setWidth(int n) {
        this.setSize(n, this.getHeight());
    }

    protected void setHeight(int n) {
        this.setSize(this.getWidth(), n);
    }
}

