/*
 * Decompiled with CFR 0.152.
 */
public class Deck
implements CardProducer {
    private long[] unusedCards;
    protected int numberOfDecks;
    protected int numUnusedCards;

    public Deck() {
        this(1);
    }

    public Deck(int n) {
        this.numberOfDecks = n;
        this.unusedCards = new long[this.numberOfDecks + 1];
        this.shuffle();
    }

    public void shuffle() {
        int n = 1;
        while (n <= this.numberOfDecks) {
            this.unusedCards[n] = 0L;
            ++n;
        }
        this.numUnusedCards = this.numberOfDecks * 52;
    }

    public Card getNextCard() {
        if (this.numUnusedCards == 0) {
            this.shuffle();
        }
        int n = (int)(Math.random() * (double)this.numUnusedCards + 1.0);
        --this.numUnusedCards;
        int n2 = 1;
        int n3 = 0;
        do {
            if (++n3 > 52) {
                ++n2;
                n3 = 1;
            }
            if ((1L << n3 - 1 & this.unusedCards[n2]) != 0L) continue;
            --n;
        } while (n != 0);
        this.unusedCards[n2] = this.unusedCards[n2] | 1L << n3 - 1;
        return new Card(n3);
    }

    public int getNumUnusedCards() {
        return this.numUnusedCards;
    }
}

