/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Hand
extends Panel
implements Selection,
MouseListener {
    private static final int chipBottom = 150;
    private static final int chipApart = 32;
    private static final int chipLeft = 2;
    private static final int maxCards = 20;
    private static final int firstCardLeft = 5;
    private static final int firstCardTop = 5;
    private static final Color squareColor = Color.white;
    private static final int squareHeight = 155;
    private static final int squareWidth = 135;
    private static final int nextCardLeft = 12;
    private static final int nextCardUp = 0;
    private static final int maxBetHeight = 100;
    private static final int actionButtonsLeft = 15;
    private static final int actionButtonsTop = 104;
    private static final int questionLeft = 5;
    private static final int questionTop = 104;
    private static final int insuranceBetXOffset = 40;
    private static final int insuranceBetYOffset = -10;
    static final int INACTIVE = 1;
    static final int WAITINGBET = 2;
    static final int BETMADE = 3;
    static final int GOTCARDS = 5;
    static final int ACTIVE = 6;
    static final int SPLITONE = 7;
    static final int HANDCOMPLETE = 8;
    static final int IWIN = 9;
    static final int ILOSE = 10;
    static final int IPUSH = 11;
    static final int NOHAND = 12;
    private static final int SIDEXOFF = 5;
    private static final int SIDEYOFF = 35;
    private static CardProducer deck;
    private static BaseStack baseStack;
    private static Frame parent;
    private static BJOptions bjOptions;
    private static Hands handController;
    private static final int TOTALPANELLEFT = 5;
    private static final int TOTALPANELTOP = 35;
    private static boolean showTotal;
    private TotalPanel totalPanel = new TotalPanel(5, 35);
    private int handStatus;
    private boolean soft;
    private int numberOfCards;
    private CardPanel[] cards;
    private boolean isSplitHand;
    private boolean noHit;
    private Bet win1;
    private Bet win2;
    private Bet bet1;
    private Bet doubleBet;
    private ActionButtons actionButtons;
    private MiniDlg question;
    private int whatQuestion;
    private InsuranceBet insuranceBet;
    private static int insuranceBetSeperation;
    private static final String[] actionStrings;

    public static void setup(Frame frame, BaseStack baseStack, CardProducer cardProducer, BJOptions bJOptions, Hands hands) {
        Hand.baseStack = baseStack;
        deck = cardProducer;
        parent = frame;
        bjOptions = bJOptions;
        handController = hands;
    }

    Hand(int n, int n2) {
        this.setLocation(n, n2);
        this.setSize(136, 156);
        this.setBackground(new Color(0, 128, 0));
        this.handStatus = 2;
        this.win1 = new Bet(66, 50, 100, baseStack);
        this.win2 = new Bet(98, 50, 100, baseStack);
        this.doubleBet = new Bet(2, 50, 100, baseStack);
        this.bet1 = new Bet(34, 50, 100, baseStack);
        this.add((Component)this.bet1, 0);
        this.add((Component)this.win1, 0);
        this.add((Component)this.win2, 0);
        this.add((Component)this.doubleBet, 0);
        this.actionButtons = new ActionButtons(this);
        this.actionButtons.setLocation(15, 104);
        this.add((Component)this.actionButtons, 0);
        this.actionButtons.setVisible(false);
        this.isSplitHand = false;
        this.cards = new CardPanel[20];
        this.setLayout(null);
    }

    private void dealCard(boolean bl) {
        ++this.numberOfCards;
        this.handStatus = 5;
        this.cards[this.numberOfCards] = new CardPanel(5 + (this.numberOfCards - 1) * 12, 5 + (this.numberOfCards - 1) * 0, deck.getNextCard(), 1, bl);
        if (bl) {
            this.cards[this.numberOfCards].setLocation(5, 35);
            this.remove(this.totalPanel);
        }
        this.add((Component)this.cards[this.numberOfCards], 0);
        if (bl) {
            this.add((Component)this.totalPanel, 0);
        }
        String string = String.valueOf(this.getValue());
        if (this.isSoft()) {
            string = String.valueOf(string) + "s";
        }
        this.totalPanel.setString(string);
        if (this.numberOfCards == 2) {
            this.add((Component)this.totalPanel, 0);
        }
        if (showTotal && this.numberOfCards >= 2) {
            this.totalPanel.setVisible(true);
        } else {
            this.totalPanel.setVisible(false);
        }
        this.cards[this.numberOfCards].addMouseListener(this);
    }

    public void dealCard() {
        this.dealCard(false);
    }

    public void placeBet(int n) {
        if (this.handStatus == 2 || this.handStatus == 3) {
            if (n + this.bet1.getAmount() > bjOptions.getMaxBet()) {
                n = bjOptions.getMaxBet() - this.bet1.getAmount();
            }
            if (n <= baseStack.countChips()) {
                this.bet1.setAmount(this.bet1.getAmount() + n);
                baseStack.removeChips(n);
                this.bet1.setBetCaption(" " + String.valueOf(this.bet1.getAmount()));
                if (this.bet1.getAmount() >= bjOptions.getMinBet()) {
                    this.handStatus = 3;
                    return;
                }
                this.handStatus = 2;
            }
        }
    }

    public int getBet() {
        return this.bet1.getAmount();
    }

    private void myTurnOver() {
        this.actionButtons.setVisible(false);
        this.update(this.getGraphics());
    }

    public void myTurn() {
        this.handStatus = 6;
        this.actionButtons.setVisible(true);
        this.drawSquare();
        if (this.numberOfCards == 1) {
            this.dealSplitCard();
        }
        this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
    }

    private void drawSquare() {
        Graphics graphics = this.getGraphics();
        graphics.setColor(squareColor);
        graphics.drawRect(0, 0, 135, 155);
    }

    private void eraseSquare() {
        Graphics graphics = this.getGraphics();
        graphics.setColor(new Color(0, 128, 0));
        graphics.drawRect(0, 0, 135, 155);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        super.paint(graphics);
        if (this.handStatus == 6) {
            graphics.setColor(squareColor);
            graphics.drawRect(0, 0, 135, 155);
        }
    }

    public int getHandStatus() {
        return this.handStatus;
    }

    public int getValue() {
        int n = 0;
        int n2 = 0;
        this.soft = false;
        int n3 = 1;
        while (n3 <= this.numberOfCards) {
            n2 += this.cards[n3].getCard().getBJValue();
            if (this.cards[n3].getCard().getRank() == 1) {
                ++n;
            }
            ++n3;
        }
        while (n2 > 21 && n > 0) {
            n2 -= 10;
            --n;
        }
        if (n > 0) {
            this.soft = true;
        }
        return n2;
    }

    public boolean isSoft() {
        return this.soft;
    }

    public void checkBJ() {
        if (this.getValue() == 21 && this.handStatus != 9) {
            this.win2.setHalf();
            this.win2.setBetCaption("  Win");
            this.win2.setAmount(this.bet1.getAmount());
            this.win1.setBetCaption("  Win");
            this.win1.setAmount(this.bet1.getAmount());
            this.handStatus = 9;
            this.actionButtons.setVisible(false);
            this.update(this.getGraphics());
        }
    }

    public void win() {
        if (this.doubleBet.getAmount() != 0) {
            this.win2.setFull();
            this.win2.setBetCaption("  Win");
            this.win2.setAmount(this.doubleBet.getAmount());
        }
        this.win1.setBetCaption("  Win");
        this.win1.setAmount(this.bet1.getAmount());
        this.handStatus = 9;
        this.actionButtons.setVisible(false);
        this.update(this.getGraphics());
    }

    public void lose() {
        this.bet1.setAmount(0);
        if (this.getValue() > 21) {
            this.bet1.setBetCaption(" Bust");
        } else {
            this.bet1.setBetCaption("  Lose");
        }
        this.doubleBet.setAmount(0);
        this.doubleBet.setBetCaption("");
        this.handStatus = 10;
        this.actionButtons.setVisible(false);
        this.update(this.getGraphics());
    }

    public void push() {
        this.handStatus = 11;
        this.bet1.setBetCaption("  Push");
        if (this.doubleBet.getAmount() != 0) {
            this.doubleBet.setBetCaption("  Push");
        }
        this.actionButtons.setVisible(false);
        this.update(this.getGraphics());
    }

    public void clearCards() {
        int n = 1;
        while (n <= this.numberOfCards) {
            this.remove(this.cards[n]);
            this.cards[n] = null;
            ++n;
        }
        this.numberOfCards = 0;
        this.isSplitHand = false;
        this.totalPanel.setVisible(false);
        this.bet1.clear();
        this.bet1.setFull();
        this.doubleBet.clear();
        this.win1.clear();
        this.win2.clear();
        this.win2.setFull();
        this.repaint();
        if (this.insuranceBet != null) {
            this.insuranceBet.clear();
            this.insuranceBet = null;
        }
        this.handStatus = 2;
    }

    public boolean getDoubleStatus() {
        if (this.noHit) {
            return false;
        }
        if (this.numberOfCards != 2) {
            return false;
        }
        if (this.isSplitHand && !Hand.bjOptions.doubleAfterSplitAllowed) {
            return false;
        }
        if (Hand.bjOptions.doubleOn_10_or_11_only) {
            return this.getValue() == 10 || this.getValue() == 11;
        }
        return true;
    }

    public void doubleDown() {
        if (bjOptions.isChecking()) {
            int n = this.getCorrectAction();
            if (n != 4) {
                this.ask(4, String.valueOf(actionStrings[n]) + " is Correct", "Double", "Cancel");
                return;
            }
            this.continueDoubleDown();
            return;
        }
        if (this.getValue() > 11 && !this.isSoft()) {
            this.ask(4, "Double hard " + String.valueOf(this.getValue()), "Yes", "Cancel");
            return;
        }
        this.continueDoubleDown();
    }

    private void continueDoubleDown() {
        if (this.getBet() > baseStack.countChips()) {
            baseStack.buyChips(this.getBet() - baseStack.countChips());
        }
        if (this.getBet() <= baseStack.countChips()) {
            this.doubleDownAmount(this.getBet());
            return;
        }
        this.doubleDownAmount(baseStack.countChips());
    }

    private void doubleDownAmount(int n) {
        if (this.handStatus == 6) {
            this.doubleBet.setAmount(n);
            baseStack.removeChips(n);
            this.doubleBet.setBetCaption("  Dbl");
            this.dealCard(true);
            this.handStatus = 8;
            if (this.getValue() > 21) {
                this.lose();
            }
            this.actionButtons.setVisible(false);
            this.update(this.getGraphics());
        }
    }

    public boolean getSplitStatus() {
        if (handController.atMaxNumHands()) {
            return false;
        }
        if (this.numberOfCards == 2 && this.cards[1].getCard().getBJValue() == this.cards[2].getCard().getBJValue()) {
            if (this.isSplitHand) {
                return Hand.bjOptions.resplitPairsAllowed;
            }
            return true;
        }
        return false;
    }

    public void split() {
        if (bjOptions.isChecking()) {
            int n = this.getCorrectAction();
            if (n != 3) {
                this.ask(3, String.valueOf(actionStrings[n]) + " is Correct", "Split", "Cancel");
                return;
            }
            handController.split();
            return;
        }
        handController.split();
    }

    private void continueSplit() {
        handController.split();
    }

    public void createSplitHand(Hand hand) {
        hand.numberOfCards = 1;
        hand.cards[1] = this.cards[2];
        this.remove(this.cards[2]);
        hand.add((Component)this.cards[2], 0);
        hand.cards[1].setX(5);
        hand.bet1.setAmount(this.bet1.getAmount());
        hand.bet1.setBetCaption("  " + String.valueOf(hand.bet1.getAmount()));
        baseStack.removeChips(hand.bet1.getAmount());
        hand.handStatus = 5;
        hand.isSplitHand = true;
        this.numberOfCards = 1;
        this.noHit = false;
        this.isSplitHand = true;
        this.dealSplitCard();
    }

    private void dealSplitCard() {
        if (this.cards[1].getCard().getRank() == 1) {
            if (Hand.bjOptions.resplitAcesAllowed) {
                this.dealCard(false);
            } else {
                this.dealCard(true);
            }
            if (this.cards[2].getCard().getRank() == 1 && Hand.bjOptions.resplitAcesAllowed) {
                this.noHit = true;
                this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
                return;
            }
            this.handStatus = 8;
            this.actionButtons.setVisible(false);
            this.update(this.getGraphics());
            return;
        }
        this.dealCard(false);
        this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
    }

    private boolean getSurrenderStatus() {
        return this.handStatus == 6 && this.numberOfCards == 2 && Hand.bjOptions.surrenderAllowed && !this.isSplitHand;
    }

    public void surrender() {
        if (bjOptions.isChecking()) {
            int n = this.getCorrectAction();
            if (n != 5) {
                this.ask(5, String.valueOf(actionStrings[n]) + " is Correct", "Surr.", "Cancel");
                return;
            }
            this.continueSurrender();
            return;
        }
        this.continueSurrender();
    }

    private void continueSurrender() {
        int n = this.bet1.getAmount();
        this.bet1.setHalf();
        this.bet1.setAmount(n);
        this.bet1.setBetCaption("  1/2");
        this.handStatus = 10;
        this.actionButtons.setVisible(false);
        this.update(this.getGraphics());
    }

    private boolean getHitStatus() {
        return !this.noHit;
    }

    private int getCorrectAction() {
        return bjOptions.checkBasicStrategy(this.getValue(), this.soft, this.getDoubleStatus(), this.getSplitStatus(), this.handStatus == 6 && this.numberOfCards == 2 && Hand.bjOptions.surrenderAllowed && !this.isSplitHand);
    }

    public void hit() {
        if (bjOptions.isChecking()) {
            int n = this.getCorrectAction();
            if (n != 1) {
                this.ask(1, String.valueOf(actionStrings[n]) + " is Correct", "Hit", "Cancel");
                return;
            }
            this.dealCard();
            if (this.getValue() > 21) {
                this.lose();
                return;
            }
            this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
            return;
        }
        if (this.getValue() >= 17 && !this.soft) {
            this.ask(1, "Hit Hard " + String.valueOf(this.getValue()) + "?", "Hit", "Cancel");
            return;
        }
        if (this.getValue() >= 20) {
            this.ask(1, "Hit Soft " + String.valueOf(this.getValue()) + "?", "Yes", "Cancel");
            return;
        }
        this.dealCard();
        if (this.getValue() > 21) {
            this.lose();
            return;
        }
        this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
    }

    private void continueHit() {
        this.dealCard();
        if (this.getValue() > 21) {
            this.lose();
            return;
        }
        this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
    }

    public void stand() {
        if (bjOptions.isChecking()) {
            int n = this.getCorrectAction();
            if (n != 2) {
                this.ask(2, String.valueOf(actionStrings[n]) + " is Correct", "Stand", "Cancel");
                return;
            }
            this.handStatus = 8;
            this.actionButtons.setVisible(false);
            this.update(this.getGraphics());
            return;
        }
        this.handStatus = 8;
        this.actionButtons.setVisible(false);
        this.update(this.getGraphics());
    }

    private void continueStand() {
        this.handStatus = 8;
        this.actionButtons.setVisible(false);
        this.update(this.getGraphics());
    }

    private void setActionButtons() {
        this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
    }

    public void done() {
        this.handStatus = 8;
    }

    public static void setShowTotal(boolean bl) {
        showTotal = bl;
    }

    public void resetShowTotal() {
        if (showTotal && this.numberOfCards >= 2) {
            this.totalPanel.setVisible(true);
            return;
        }
        this.totalPanel.setVisible(false);
    }

    public int getX() {
        return this.getLocation().x;
    }

    public int getY() {
        return this.getLocation().y;
    }

    public void askForInsurance() {
        this.ask(6, "Insurance?", this.getValue() == 21 ? "Even $" : "Yes", "No");
    }

    public void continueInsurance() {
        if (this.getValue() == 21) {
            this.win();
            return;
        }
        this.insuranceBet = new InsuranceBet(this.getLocation().x + 40, this.getLocation().y + -10, insuranceBetSeperation, baseStack);
        if (this.getBet() > baseStack.countHalfChips()) {
            baseStack.buyChips((this.getBet() - baseStack.countHalfChips() + 1) / 2);
        }
        this.insuranceBet.setBet(this.getBet());
        baseStack.removeHalf(this.insuranceBet.getBet());
        parent.repaint();
    }

    public boolean isInsuranceDone() {
        return this.question == null;
    }

    public void dealerHasBJ(boolean bl) {
        if (this.insuranceBet != null) {
            if (bl && this.insuranceBet != null) {
                this.insuranceBet.win();
            } else {
                this.insuranceBet.lose();
            }
            parent.repaint();
        }
    }

    public void paintInsuranceBet(Graphics graphics) {
        if (this.insuranceBet != null) {
            this.insuranceBet.paint(graphics);
        }
    }

    public boolean insuranceBetMade() {
        return this.insuranceBet != null;
    }

    private void ask(int n, String string, String string2, String string3) {
        this.whatQuestion = n;
        this.question = new MiniDlg(string, string2, string3, this);
        this.question.setLocation(5, 104);
        this.add((Component)this.question, 0);
    }

    public void selectYes() {
        this.remove(this.question);
        this.question = null;
        switch (this.whatQuestion) {
            case 1: {
                this.dealCard();
                if (this.getValue() > 21) {
                    this.lose();
                    return;
                }
                this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
                return;
            }
            case 2: {
                this.handStatus = 8;
                this.actionButtons.setVisible(false);
                this.update(this.getGraphics());
                return;
            }
            case 4: {
                this.continueDoubleDown();
                return;
            }
            case 3: {
                handController.split();
                return;
            }
            case 5: {
                this.continueSurrender();
                return;
            }
            case 6: {
                this.continueInsurance();
                return;
            }
        }
    }

    public void selectNo() {
        this.remove(this.question);
        this.question = null;
        if (this.handStatus == 6) {
            this.actionButtons.setButtons(!this.noHit, true, this.getSplitStatus(), this.getDoubleStatus());
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0 && this.handStatus == 6 && this.numberOfCards == 2 && Hand.bjOptions.surrenderAllowed && !this.isSplitHand) {
            this.surrender();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static {
        insuranceBetSeperation = 38;
        actionStrings = new String[]{"", "Hit", "Stand", "Split", "Double", "Surrender"};
    }
}

