/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class Hands
implements MouseListener {
    final int maxHands = 5;
    final int halfHandWidth = -70;
    final int handHeight = 155;
    Frame parent;
    BJOptions bjOptions;
    int top;
    int center;
    int numHands;
    int numStartHands;
    Hand[] hand;
    int currentHand;
    BaseStack baseStack;
    boolean newBetMade;

    Hands(Frame frame, int n, int n2, BaseStack baseStack, CardProducer cardProducer, BJOptions bJOptions) {
        this.parent = frame;
        Hand.setup(frame, baseStack, cardProducer, bJOptions, this);
        this.baseStack = baseStack;
        this.top = n2 - 155 - 1;
        this.center = n;
        this.bjOptions = bJOptions;
        this.numHands = 0;
        this.currentHand = 0;
        this.hand = new Hand[6];
        int n3 = 1;
        while (n3 <= 5) {
            this.hand[n3] = new Hand(this.center - -70, this.top);
            this.hand[n3].setVisible(false);
            this.parent.add(this.hand[n3]);
            ++n3;
        }
        this.baseStack.addMouseListener(this);
    }

    public int getTotalBet() {
        int n = 0;
        int n2 = 1;
        while (n2 <= this.numHands) {
            n += this.hand[n2].getBet();
            ++n2;
        }
        return n;
    }

    public boolean atMaxNumHands() {
        return this.numHands == 5;
    }

    public void split() {
        if (this.numHands < 5) {
            if (this.hand[this.currentHand].getBet() > this.baseStack.countChips()) {
                this.baseStack.buyChips(this.hand[this.currentHand].getBet() - this.baseStack.countChips());
            }
            if (this.hand[this.currentHand].getBet() <= this.baseStack.countChips()) {
                Hand hand = this.hand[this.numHands + 1];
                int n = 1;
                while (n <= this.currentHand) {
                    this.hand[n].setLocation(this.hand[n].getX() - -70, this.hand[n].getY());
                    ++n;
                }
                int n2 = this.numHands;
                while (n2 >= this.currentHand + 1) {
                    this.hand[n2].setLocation(this.hand[n2].getX() + -70, this.hand[n2].getY());
                    this.hand[n2 + 1] = this.hand[n2];
                    --n2;
                }
                ++this.numHands;
                this.hand[this.currentHand + 1] = hand;
                this.hand[this.currentHand].createSplitHand(this.hand[this.currentHand + 1]);
                this.hand[this.currentHand + 1].setLocation(this.hand[this.currentHand].getLocation().x + -140, this.top);
                this.hand[this.currentHand + 1].setVisible(true);
            }
        }
    }

    public void increaseBets(int n) {
        this.newBetMade = true;
        if (n + (this.numHands == 0 ? 0 : this.hand[1].getBet()) > this.bjOptions.getMaxBet()) {
            n = this.bjOptions.getMaxBet() - (this.numHands == 0 ? 0 : this.hand[1].getBet());
        }
        if (n + (this.numHands == 0 ? 0 : this.hand[1].getBet()) < this.bjOptions.getMinBet()) {
            n = this.bjOptions.getMinBet() - (this.numHands == 0 ? 0 : this.hand[1].getBet());
        }
        if (n * this.numStartHands > this.baseStack.countChips() && !this.baseStack.buyChips(n * this.numStartHands - this.baseStack.countChips())) {
            return;
        }
        int n2 = this.center - this.numStartHands * -70;
        int n3 = 1;
        while (n3 <= this.numStartHands) {
            if (!this.hand[n3].isVisible()) {
                this.hand[n3].setLocation(n2 + (n3 - 1) * 2 * -70, this.top);
                this.hand[n3].setVisible(true);
            }
            this.hand[n3].placeBet(n);
            ++n3;
        }
        this.numHands = this.numStartHands;
    }

    public void setNumStartHands(int n) {
        if (this.numStartHands != n) {
            this.clear();
            this.numStartHands = n;
            this.bjOptions.setnumHandsPlayed(n);
        }
    }

    public boolean dealCard() {
        if (this.currentHand == 0) {
            this.currentHand = 1;
        }
        this.hand[this.currentHand].dealCard();
        ++this.currentHand;
        if (this.currentHand > this.numHands) {
            this.currentHand = 0;
            return true;
        }
        return false;
    }

    public void done() {
        int n = 1;
        while (n <= this.numHands) {
            this.hand[n].done();
            ++n;
        }
    }

    public void checkBJs() {
        int n = 1;
        while (n <= this.numHands) {
            this.hand[n].checkBJ();
            ++n;
        }
    }

    public boolean handsComplete() {
        if (this.currentHand == 0) {
            this.currentHand = 1;
        }
        boolean bl = false;
        switch (this.hand[this.currentHand].getHandStatus()) {
            case 5: {
                this.hand[this.currentHand].myTurn();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                ++this.currentHand;
                if (this.currentHand <= this.numHands) break;
                bl = true;
                this.currentHand = 0;
            }
        }
        return bl;
    }

    public boolean allHandsDetermined() {
        int n = 1;
        while (n <= this.numHands) {
            if (this.hand[n].getHandStatus() == 8) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void determineResults(int n) {
        int n2 = 1;
        while (n2 <= this.numHands) {
            if (this.hand[n2].getHandStatus() == 8) {
                if (this.hand[n2].getValue() > n) {
                    this.hand[n2].win();
                }
                if (this.hand[n2].getValue() == n) {
                    this.hand[n2].push();
                }
                if (this.hand[n2].getValue() < n) {
                    this.hand[n2].lose();
                }
            }
            ++n2;
        }
    }

    public void clear() {
        this.currentHand = 0;
        this.numHands = 0;
        this.newBetMade = true;
        int n = 1;
        while (n <= 5) {
            this.hand[n].setVisible(false);
            this.hand[n].clearCards();
            ++n;
        }
    }

    public boolean isNewBetMade() {
        boolean bl = this.newBetMade;
        this.newBetMade = false;
        return bl;
    }

    public boolean betsMade() {
        if (this.numHands == 0) {
            return false;
        }
        int n = 1;
        while (n <= this.numHands) {
            if (this.hand[n].getBet() < this.bjOptions.getMinBet()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private int getCurrentBet() {
        if (this.numHands == 0) {
            return 0;
        }
        return this.hand[1].getBet();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            ChipStack chipStack = (ChipStack)mouseEvent.getComponent();
            int n = chipStack.getChipValue();
            if (this.numHands == 0) {
                this.increaseBets(n);
                this.newBetMade = true;
            } else if (this.hand[1].getHandStatus() == 3 || this.hand[1].getHandStatus() == 2) {
                this.increaseBets(n);
                this.newBetMade = true;
            }
        }
        if ((mouseEvent.getModifiers() & 4) != 0 && this.numHands != 0 && (this.hand[1].getHandStatus() == 3 || this.hand[1].getHandStatus() == 2)) {
            this.clear();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void setShowTotal(boolean bl) {
        Hand.setShowTotal(bl);
        int n = 1;
        while (n <= this.numHands) {
            this.hand[n].resetShowTotal();
            ++n;
        }
    }

    public void askForInsurance() {
        int n = 1;
        while (n <= this.numHands) {
            this.hand[n].askForInsurance();
            ++n;
        }
    }

    public boolean isInsuranceDone() {
        int n = 1;
        while (n <= this.numHands) {
            if (!this.hand[n].isInsuranceDone()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void dealerHasBJ(boolean bl) {
        int n = 1;
        while (n <= this.numHands) {
            this.hand[n].dealerHasBJ(bl);
            ++n;
        }
    }

    public void paintInsuranceBet(Graphics graphics) {
        int n = 1;
        while (n <= this.numHands) {
            this.hand[n].paintInsuranceBet(graphics);
            ++n;
        }
    }

    public synchronized boolean insuranceBetMade() {
        int n = 1;
        while (n <= this.numHands) {
            if (this.hand[n].insuranceBetMade()) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

